/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.model.part;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.model.part.LayerModel;
import noppes.npcs.client.model.part.ModelEyeData;
import noppes.npcs.constants.EnumParts;

public class ModelDataShared {
    protected ModelPartConfig arm1 = new ModelPartConfig();
    protected ModelPartConfig arm2 = new ModelPartConfig();
    protected ModelPartConfig arm3 = new ModelPartConfig();
    protected ModelPartConfig arm4 = new ModelPartConfig();
    protected ModelPartConfig body = new ModelPartConfig();
    protected ModelPartConfig head = new ModelPartConfig();
    protected ModelPartConfig leg1 = new ModelPartConfig();
    protected ModelPartConfig leg2 = new ModelPartConfig();
    protected ModelPartConfig leg3 = new ModelPartConfig();
    protected ModelPartConfig leg4 = new ModelPartConfig();
    protected ModelPartData legParts = new ModelPartData("legs");
    protected HashMap<EnumParts, ModelPartData> parts = new HashMap();
    protected final Map<Integer, LayerModel> layersData = new TreeMap<Integer, LayerModel>();
    private final List<String> disableLayers = new ArrayList<String>();
    public EntityLivingBase entity;
    public Class<? extends EntityLivingBase> entityClass;
    public NBTTagCompound extra = new NBTTagCompound();
    public ModelEyeData eyes = new ModelEyeData();

    public void clearEntity() {
        this.entity = null;
    }

    public float getBodyX() {
        return (1.0f - Math.max(this.body.scale[0], this.body.scale[2])) * 0.75f + this.getLegsX();
    }

    public float getBodyY() {
        return (1.0f - this.body.scale[1]) * 0.75f + this.getLegsY();
    }

    public Class<? extends EntityLivingBase> getEntityClass() {
        return this.entityClass;
    }

    public float getLegsX() {
        ModelPartConfig legs = this.leg1;
        if (this.leg2.notShared) {
            float s0 = Math.max(this.leg1.scale[0], this.leg1.scale[2]);
            float s1 = Math.max(this.leg2.scale[0], this.leg2.scale[2]);
            if (s1 > s0) {
                legs = this.leg2;
            }
        }
        return (1.0f - Math.max(legs.scale[0], legs.scale[2])) * 0.75f;
    }

    public float getLegsY() {
        ModelPartConfig legs = this.leg1;
        if (this.leg2.notShared && this.leg2.scale[1] > this.leg1.scale[1]) {
            legs = this.leg2;
        }
        return (1.0f - legs.scale[1]) * 0.75f;
    }

    public ModelPartData getOrCreatePart(EnumParts type) {
        if (type == null) {
            return null;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        ModelPartData part = this.getPartData(type);
        if (part == null) {
            part = new ModelPartData(type.name);
            this.parts.put(type, part);
        }
        return part;
    }

    public ModelPartConfig getPartConfig(EnumParts type) {
        switch (type) {
            case HEAD: {
                return this.head;
            }
            case BODY: {
                return this.body;
            }
            case ARM_LEFT: {
                return this.arm1;
            }
            case ARM_RIGHT: {
                return this.arm2;
            }
            case LEG_LEFT: {
                return this.leg1;
            }
            case LEG_RIGHT: {
                return this.leg2;
            }
            case WRIST_LEFT: {
                return this.arm3;
            }
            case WRIST_RIGHT: {
                return this.arm4;
            }
            case FOOT_LEFT: {
                return this.leg3;
            }
            case FOOT_RIGHT: {
                return this.leg4;
            }
        }
        return null;
    }

    public ModelPartData getPartData(EnumParts type) {
        if (type == EnumParts.LEGS) {
            return this.legParts;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        return this.parts.get((Object)type);
    }

    public void load(NBTTagCompound compound) {
        this.setEntityName(compound.func_74779_i("EntityClass"));
        this.arm1.load(compound.func_74775_l("ArmsConfig"));
        this.arm2.load(compound.func_74775_l("ArmsConfig" + (this.arm1.notShared ? "2" : "")));
        if (compound.func_150297_b("ArmsConfig3", 10)) {
            this.arm3.load(compound.func_74775_l("ArmsConfig3"));
            this.arm4.load(compound.func_74775_l("ArmsConfig" + (this.arm1.notShared ? "4" : "3")));
        }
        this.body.load(compound.func_74775_l("BodyConfig"));
        this.leg1.load(compound.func_74775_l("LegsConfig"));
        this.leg2.load(compound.func_74775_l("LegsConfig" + (this.leg1.notShared ? "2" : "")));
        if (compound.func_150297_b("LegsConfig3", 10)) {
            this.leg3.load(compound.func_74775_l("LegsConfig3"));
            this.leg4.load(compound.func_74775_l("LegsConfig" + (this.leg1.notShared ? "4" : "3")));
        }
        this.head.load(compound.func_74775_l("HeadConfig"));
        this.legParts.load(compound.func_74775_l("LegParts"));
        this.eyes.load(compound.func_74775_l("Eyes"));
        this.extra = compound.func_74775_l("ExtraData");
        this.parts.clear();
        NBTTagList listP = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < listP.func_74745_c(); ++i) {
            NBTTagCompound item = listP.func_150305_b(i);
            String name = item.func_74779_i("PartName");
            ModelPartData part = new ModelPartData(name);
            part.load(item);
            EnumParts e = EnumParts.FromName(name);
            if (e == null) continue;
            this.parts.put(e, part);
        }
        this.layersData.clear();
        if (compound.func_150297_b("LayersData", 9)) {
            NBTTagList listLD = compound.func_150295_c("LayersData", 10);
            for (int i = 0; i < listLD.func_74745_c(); ++i) {
                LayerModel lm = new LayerModel(listLD.func_150305_b(i));
                this.layersData.put(lm.slotID, lm);
            }
        }
        this.disableLayers.clear();
        if (compound.func_150297_b("DisableLayers", 9)) {
            NBTTagList listDL = compound.func_150295_c("DisableLayers", 8);
            for (int i = 0; i < listDL.func_74745_c(); ++i) {
                this.disableLayers.add(listDL.func_150307_f(i));
            }
        }
        this.updateTranslate();
    }

    public void removePart(EnumParts type) {
        this.parts.remove((Object)type);
    }

    public void setEntityClass(Class<? extends EntityLivingBase> entityClassIn) {
        this.entityClass = entityClassIn;
        this.entity = null;
        this.extra = new NBTTagCompound();
    }

    public void setEntityName(String string) {
        this.entityClass = null;
        this.entity = null;
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            try {
                Class c = ent.getEntityClass();
                if (!c.getCanonicalName().equals(string) || !EntityLivingBase.class.isAssignableFrom(c)) continue;
                this.entityClass = c.asSubclass(EntityLivingBase.class);
                break;
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
    }

    private void updateTranslate() {
        block7: for (EnumParts part : EnumParts.values()) {
            ModelPartConfig config = this.getPartConfig(part);
            if (config == null) continue;
            switch (part) {
                case HEAD: 
                case BODY: {
                    config.setTranslate(0.0f, this.getBodyY(), 0.0f);
                    continue block7;
                }
                case ARM_LEFT: {
                    ModelPartConfig body = this.getPartConfig(EnumParts.BODY);
                    float x = (1.0f - body.scale[0]) * 0.25f + (1.0f - config.scale[0]) * 0.075f;
                    float y = this.getBodyY() + (1.0f - config.scale[1]) * -0.1f;
                    config.setTranslate(-x, y, 0.0f);
                    if (config.notShared) continue block7;
                    ModelPartConfig arm = this.getPartConfig(EnumParts.ARM_RIGHT);
                    arm.copyValues(config);
                    continue block7;
                }
                case ARM_RIGHT: {
                    ModelPartConfig body = this.getPartConfig(EnumParts.BODY);
                    float x = (1.0f - body.scale[0]) * 0.25f + (1.0f - config.scale[0]) * 0.075f;
                    float y = this.getBodyY() + (1.0f - config.scale[1]) * -0.1f;
                    config.setTranslate(x, y, 0.0f);
                    continue block7;
                }
                case LEG_LEFT: {
                    config.setTranslate(config.scale[0] * 0.125f - 0.113f, this.getLegsY(), 0.0f);
                    if (config.notShared) continue block7;
                    ModelPartConfig leg = this.getPartConfig(EnumParts.LEG_RIGHT);
                    leg.copyValues(config);
                    continue block7;
                }
                case LEG_RIGHT: {
                    config.setTranslate((1.0f - config.scale[0]) * 0.125f, this.getLegsY(), 0.0f);
                }
            }
        }
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.entityClass != null) {
            compound.func_74778_a("EntityClass", this.entityClass.getCanonicalName());
        }
        compound.func_74782_a("ArmsConfig", (NBTBase)this.arm1.save());
        compound.func_74782_a("ArmsConfig2", (NBTBase)this.arm2.save());
        compound.func_74782_a("ArmsConfig3", (NBTBase)this.arm3.save());
        compound.func_74782_a("ArmsConfig4", (NBTBase)this.arm4.save());
        compound.func_74782_a("BodyConfig", (NBTBase)this.body.save());
        compound.func_74782_a("LegsConfig", (NBTBase)this.leg1.save());
        compound.func_74782_a("LegsConfig2", (NBTBase)this.leg2.save());
        compound.func_74782_a("LegsConfig3", (NBTBase)this.leg3.save());
        compound.func_74782_a("LegsConfig4", (NBTBase)this.leg4.save());
        compound.func_74782_a("HeadConfig", (NBTBase)this.head.save());
        compound.func_74782_a("LegParts", (NBTBase)this.legParts.save());
        compound.func_74782_a("Eyes", (NBTBase)this.eyes.save());
        compound.func_74782_a("ExtraData", (NBTBase)this.extra);
        NBTTagList listP = new NBTTagList();
        for (EnumParts enumParts : this.parts.keySet()) {
            NBTTagCompound item = this.parts.get((Object)enumParts).save();
            item.func_74778_a("PartName", enumParts.name);
            listP.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("Parts", (NBTBase)listP);
        NBTTagList listLD = new NBTTagList();
        for (LayerModel lm : new ArrayList<LayerModel>(this.layersData.values())) {
            listLD.func_74742_a((NBTBase)lm.save());
        }
        compound.func_74782_a("LayersData", (NBTBase)listLD);
        NBTTagList nBTTagList = new NBTTagList();
        for (String layer : this.disableLayers) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagString(layer));
        }
        compound.func_74782_a("DisableLayers", (NBTBase)nBTTagList);
        return compound;
    }

    public int addNewLayer() {
        int slotID = this.layersData.size();
        LayerModel lm = new LayerModel();
        lm.slotID = slotID;
        this.layersData.put(slotID, lm);
        return slotID;
    }

    public int removeLayer(int slotID) {
        TreeMap<Integer, LayerModel> newLayersData = new TreeMap<Integer, LayerModel>();
        int id = 0;
        for (LayerModel lm : new ArrayList<LayerModel>(this.layersData.values())) {
            if (lm.slotID == slotID) continue;
            lm.slotID = id++;
            newLayersData.put(lm.slotID, lm);
        }
        if (newLayersData.size() != this.layersData.size()) {
            this.layersData.clear();
            this.layersData.putAll(newLayersData);
            return Math.max(-1, slotID - 1);
        }
        return slotID;
    }

    @Nonnull
    public List<String> getLayerKeys() {
        ArrayList<String> list = new ArrayList<String>();
        for (LayerModel lm : new ArrayList<LayerModel>(this.layersData.values())) {
            String k;
            String key = lm.slotID + 1 + ": ";
            key = lm.getOBJ() != null ? ((k = lm.getOBJ().func_110623_a()).lastIndexOf("/") != -1 ? key + k.substring(k.lastIndexOf("/") + 1) : (k.lastIndexOf(":") != -1 ? key + k.substring(k.lastIndexOf(":") + 1) : key + k)) : key + lm.getStack().func_82833_r();
            list.add(key);
        }
        return list;
    }

    public LayerModel getLayerModel(int slotID) {
        if (this.layersData.containsKey(slotID)) {
            return this.layersData.get(slotID);
        }
        if (slotID == this.layersData.size()) {
            return this.layersData.get(this.addNewLayer());
        }
        return null;
    }

    public List<LayerModel> getRenderLayers(EnumParts part) {
        ArrayList<LayerModel> list = new ArrayList<LayerModel>();
        for (LayerModel lm : new ArrayList<LayerModel>(this.layersData.values())) {
            if (lm.part != part) continue;
            list.add(lm);
        }
        return list;
    }

    public boolean isNoEmptyLayer() {
        for (LayerModel lm : new ArrayList<LayerModel>(this.layersData.values())) {
            if (!lm.getStack().func_190926_b() || lm.getOBJ() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isDisableLayer(String layerName) {
        return this.disableLayers.contains(layerName);
    }

    public String[] getDisableLayers() {
        return this.disableLayers.toArray(new String[0]);
    }

    public void setDisableLayers(String[] newLayers) {
        this.disableLayers.clear();
        if (newLayers != null && newLayers.length != 0) {
            this.disableLayers.addAll(Arrays.asList(newLayers));
        }
    }
}

